use mavenfuzzyfactory;

-- Yêu cầu 1 – Phân tích Product-Level Salesorders
select year(created_at) yr, month(created_at) mo,
	count(distinct order_id) number_of_orders,
    sum(price_usd) total_revenue,
    sum(price_usd) - sum(cogs_usd) total_margin
from orders
where created_at < '2013-01-04'
group by yr, mo
order by yr, mo;

-- Yêu cầu 2 – Phân tích Product Launches
select year(website_sessions.created_at) yr, month(website_sessions.created_at) mo,
	count(distinct website_sessions.website_session_id) sessions,
	count(distinct order_id) orders,
    count(distinct order_id) / count(distinct website_sessions.website_session_id) conv_rate,
    sum(price_usd) / count(distinct website_sessions.website_session_id) revenue_per_session
from website_sessions left join orders
	on website_sessions.website_session_id = orders.website_session_id
where website_sessions.created_at > '2012-04-01' and website_sessions.created_at < '2013-04-01'
group by yr, mo
order by yr, mo;

-- Yêu cầu 3 – Phân tích Product-Level Website Pathing
-- Bước 1: Trong bảng website_pageviews , lấy ra tất cả các web_session trong khoảng từ
-- 06-10-2012 đến 06-04-2013 có pageview_url = /products. Nếu các phiên được tạo trước
-- ngày 06-01-2013 thì sẽ được gán là ‘A. Pre_Product_2’, ngược lại sẽ gán là 'B.Post_Product_2'.
drop table if exists web_sessions_product_period;
create temporary table if not exists web_sessions_product_period
select website_session_id, website_pageview_id, created_at,
	if (created_at < '2013-01-06', 'A. Pre_Product_2', 'B.Post_Product_2') time_period
from website_pageviews
where created_at > '2012-10-06' and created_at < '2013-04-06'
	and pageview_url = '/products';
select * from web_sessions_product_period;

-- Bước 2: Viết truy vấn lấy ra các website_pageview_id ngay sau khi người dùng truy cập
-- vào /products (sử dụng kết quả của bước 1 kết hợp với bảng website_pageviews) .
create temporary table if not exists web_sessions_product_next_page_id
select time_period, website_pageviews.website_session_id,
	min(if (website_pageviews.website_pageview_id > web_sessions_product_period.website_pageview_id, website_pageviews.website_pageview_id, null )) min_next_pageview_id
from website_pageviews left join web_sessions_product_period
	on website_pageviews.website_session_id = web_sessions_product_period.website_session_id
where web_sessions_product_period.time_period is not null
group by time_period, website_pageviews.website_session_id;

-- Bước 3: Viết truy vấn lấy ra tên các website_pageview_id vừa tìm được ở bước 2.
create temporary table if not exists web_sessions_product_next_page_url
select time_period, website_pageviews.website_session_id,
	min(if (web_sessions_product_next_page_id.min_next_pageview_id = website_pageviews.website_pageview_id, website_pageviews.pageview_url, null)) next_pageview_url
from website_pageviews left join web_sessions_product_next_page_id
	on website_pageviews.website_session_id = web_sessions_product_next_page_id.website_session_id
	-- c.min_next_pageview_id = d.website_pageview_id
where web_sessions_product_next_page_id.website_session_id is not null
group by time_period, website_pageviews.website_session_id;

-- select next_pageview_url from web_sessions_product_next_page_url group by next_pageview_url;

-- Bước 4: Viết truy vấn để trả về các chỉ số sau
-- Tên của loại phiên (‘A. Pre_Product_2’ hoặc 'B. Post_Product_2')
-- Tổng số session
-- Số session tiếp tục truy cập vào trang tiếp theo của trang /products
-- Tỷ lệ session tiếp tục truy cập vào trang tiếp theo của trang /products trên tổng số các session
-- Số session và tỷ lệ session truy cập vào từng trang sau trang /products
select time_period, count(website_session_id) sessions, count(next_pageview_url) w_next_pg,
	count(next_pageview_url) / count(website_session_id) pct_to_next_pg,
	sum(if(next_pageview_url = '/the-original-mr-fuzzy', 1, 0)) to_mrfuzzy,
    sum(if(next_pageview_url = '/the-original-mr-fuzzy', 1, 0))/count(website_session_id) pct_to_mrfuzzy,
	sum(if(next_pageview_url = '/the-forever-love-bear', 1, 0)) to_lovebear,
    sum(if(next_pageview_url = '/the-forever-love-bear', 1, 0))/count(website_session_id) pct_to_lovebear
from web_sessions_product_next_page_url
group by time_period;
